<?php
/*--------------------------------------------------------------
   GambioVisitorsTrend.php 2021-08-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities\WidgetDefinition;

use Doctrine\DBAL\Connection;
use Gambio\Admin\Modules\Statistics\App\Data\Factory as DataFactory;
use Gambio\Admin\Modules\Statistics\App\Overview\Factory as OverviewFactory;
use Gambio\Admin\Modules\Statistics\App\Overview\Factory\Option\Predefined\TimespanDropdown;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\Options;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;
use Gambio\Core\Application\ValueObjects\UserPreferences;

class GambioVisitorsTrend extends GambioWidgetDefinition
{
    private const TYPE = 'gambio.visitors.trend';
    
    private const VERSION = '0.1.0';
    
    private const ICON = "data:image/png;base64,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";
    
    private const WIDGET_TITLE = [
        self::LANGUAGE_CODE_GERMAN  => 'Besucher (Trend)',
        self::LANGUAGE_CODE_ENGLISH => 'Visitors (Trend)'
    ];
    
    private const CATEGORY_TITLE = [
        self::LANGUAGE_CODE_GERMAN  => 'Besucher',
        self::LANGUAGE_CODE_ENGLISH => 'Visitors'
    ];
    
    /**
     * @var DataFactory
     */
    private $dataFactory;
    
    /**
     * @var UserPreferences
     */
    private $userPreferences;
    
    /**
     * @var Connection
     */
    private $connection;
    
    
    /**
     * @inheritDoc
     */
    public function __construct(
        OverviewFactory $overviewFactory,
        DataFactory $dataFactory,
        UserPreferences $userPreferences,
        Connection $connection
    ) {
        $this->dataFactory     = $dataFactory;
        $this->userPreferences = $userPreferences;
        $this->connection      = $connection;
        
        parent::__construct($overviewFactory->createType(self::TYPE),
                            $overviewFactory->createVersion(self::VERSION),
                            $overviewFactory->createIconUsingData(self::ICON),
                            $overviewFactory->useVisualizations()->createAreaChart(),
                            $overviewFactory->useOptions()->createOptions($overviewFactory->useOptions()
                                                                              ->usePredefined()
                                                                              ->createTimespanDropdown($overviewFactory)),
                            $overviewFactory->createTitles($overviewFactory->createTitle($overviewFactory->createLanguageCode(self::LANGUAGE_CODE_GERMAN),
                                                                                         self::WIDGET_TITLE[self::LANGUAGE_CODE_GERMAN]),
                                                           $overviewFactory->createTitle($overviewFactory->createLanguageCode(self::LANGUAGE_CODE_ENGLISH),
                                                                                         self::WIDGET_TITLE[self::LANGUAGE_CODE_ENGLISH])));
    }
    
    
    /**
     * @inheritDoc
     */
    public function data(Options $options): Data
    {
        $categories    = [];
        $values        = [];
        $categoryTitle = self::CATEGORY_TITLE[$this->userPreferences->languageId()
                                              === self::LANGUAGE_ID_GERMAN ? self::LANGUAGE_CODE_GERMAN : self::LANGUAGE_CODE_ENGLISH];
        $timespan      = $this->dataFactory->useTimespan()->createFromTerm($options->getById(TimespanDropdown::ID)
                                                                               ->value());
        $visitors      = $this->connection->createQueryBuilder()
            ->select([
                         'SUM(gm_counter_visits_total) AS amount',
                         'UNIX_TIMESTAMP(DATE(gm_counter_date)) AS date'
                     ])
            ->from('gm_counter_visits')
            ->where('gm_counter_date BETWEEN :startDate AND :endDate')
            ->groupBy('date')
            ->orderBy('date')
            ->setParameters([
                                ':startDate' => $timespan->startDate()->format(self::QUERY_TIMESPAN_FORMAT_DATE_START),
                                ':endDate'   => $timespan->endDate()->format(self::QUERY_TIMESPAN_FORMAT_DATE_END)
                            ])
            ->execute()
            ->fetchAll();
        
        foreach ($visitors as $visitor) {
            $categories[] = $this->dataFactory->useSerialData()->createCategory($visitor['date']);
            $values[]     = $this->dataFactory->useSerialData()->createItemValue((int)$visitor['amount']);
        }
        
        return $this->dataFactory->useSerialData()->createSerialData($this->dataFactory->useSerialData()
                                                                         ->createCategories(...$categories),
                                                                     $this->dataFactory->useSerialData()
                                                                         ->createItems($this->dataFactory->useSerialData()
                                                                                           ->createItem($this->dataFactory->useSerialData()
                                                                                                            ->createItemTitle($categoryTitle),
                                                                                                        $this->dataFactory->useSerialData()
                                                                                                            ->createItemValues(...
                                                                                                                $values))));
    }
}
